<?php
session_start();

// si la page est appelée avec ?logout 
// on détruit la variable de session 
if(isset($_GET['logout'])){ 
	unset($_SESSION['auth']);
	session_destroy();
	header('Location: ./');
    die();
}

// grain de sel pour le hash
$salt = 'Kr4-sFga_88.aplFkz-t7w9r_D';

// liste des utilisateurs et de leur mot de passe
$listUsers = array(
		md5("admin".$salt) => md5("password".$salt),
		// md5("login".$salt) => md5("password".$salt),
	);

//extention des fichiers
define("EXT", ".xx");

///////////////////////////
/******* FONCTIONS *******/

// recupérer la liste des fichiers.xx dans $folder
function getFileList($urlFolder){
	$fileList = array();
	$handle = opendir($urlFolder);
	while (false !== ($entry = readdir($handle))) {
		if($entry != '.' && $entry != '..' && !is_file($entry) && preg_match("|".EXT."$|", $entry) )
			$fileList[] = removExt($entry);
	}
	closedir($handle);
	return $fileList;
}

// restriction sur le nom des fichiers.xx
// si le nom est valide on cré la note et on redirige
// sinon retourne un message à $content (#content)
function checkName($name, $folder){
	if($name != '' && preg_match("|^[a-zA-Z0-9_-]{3,15}$|", $name) ){
		touch($folder.$name.EXT);
		header('Location: ./?note='.$name);
    	exit();
	}else{ // $contents
		return '<span class="warning">NOM DE FICHIER INCORRECT:<br />&nbsp; De 3 à 15 caractères alphanumériques [a-zA-Z0-9_-] sans accent sans espace ni autre symbole exepté le tiret (-) et le tiret bas (_).</span>';
	}
}

// supprimer la dernière extention d'une chaine
function removExt($str){ 
    if(strrpos($str, ".")===false) return $str;
    else return substr($str, 0, strrpos($str, "."));
}

/***** FIN FONCTIONS *****/
///////////////////////////

///////////////////////////
/******* CONNEXION *******/

// pas d'autentification: 
// on affiche une page vide pour que le userscript.js
// puisse incruster le formulaire de connexion
if (!isset($_SESSION['auth']) && !isset($_POST['l'])) {
	echo "<!doctype html>\n<html lang='fr'>\n<head>\n";
	echo "\t<meta charset='utf-8'>\n\t<title>allo</title>\n";
	echo "</head>\n<body>\n\n</body>\n</html>";
	die();
} 
// demande de connexion: l = login p = password
elseif (isset($_POST['l']) && isset($_POST['p']) && !isset($_SESSION['auth'])){
	$l = md5($_POST['l'].$salt);
	$p = md5($_POST['p'].$salt);
	// si la demande de connexion est acceptée 
	// on instancie la var de session à $_POST['l'] (login)
	if (array_key_exists($l, $listUsers) && $listUsers[$l] === $p)
		$_SESSION['auth'] = $_POST['l'];
	// dans touts les cas reload ...
	header('Location: ./');
    exit();
} 
// utilisateur authentifié:
// la distribution de document est activé
elseif (isset($_SESSION['auth']) && array_key_exists(md5($_SESSION['auth'].$salt), $listUsers) ) {
	// répertoire contenant toutes les notes
	// ce répertoire doit avoir les droits en écriture
	$folder = 'notes/';
	// liste de tout les fichiers.xx contenus dans $folder
	$listOfFiles = getFileList($folder);
	// contenu affichable dans div id="content"
	$contents = '';

	// demande d'ouverture d'une note, on verifie qu'elle existe réèlement
	if ( isset($_GET['note']) && in_array($_GET['note'], $listOfFiles) ){
		if ( !isset($_POST['save']) ){ //lecture du document
			$fichier = fopen($folder.$_GET['note'].EXT, 'r');
			$contents = @fread($fichier, filesize($folder.$_GET['note'].EXT));
			fclose($fichier);
		} else { // sauvegarde du document
			// verifier l'intégrité du document (que des nombres)
			if(preg_match('|[a-zA-Z]|', $_POST['save']))
				die();
			$fichier = fopen($folder.$_GET['note'].EXT, "w+");
			fputs($fichier, $_POST['save']);
			fclose($fichier);
			header('Location: '.$_SERVER['HTTP_REFERER']);
	    	exit();
		}
	}
	// l'utilisateur demande à créer une nouvelle note.xx
	if (isset($_POST['new']) ){
		$contents = checkName($_POST['new'], $folder);
	}

	?>

	<!doctype html>
	<html lang="fr">
	<head>
	    <meta charset="utf-8">
	    <title>Notes</title>
	    <link rel="stylesheet" href="style.css">
	</head>
	<body>
	<div id="menu">
	    <select name="noteslist" id="noteslist" onchange="window.location.href='?note=' + this.options[this.selectedIndex].value">
	        <option value="0"> Notes </option>
	        <?php 
	        	// création de la liste déroulante des fichiers existants
	            foreach ($listOfFiles as $value) {
	                $s = ( preg_match("|".$value."$|", $_SERVER['QUERY_STRING']) )  ? 'selected' : '' ;
	                echo '<option value="'.$value.'" '.$s.'> '.$value.' </option>'; 
	            }
	        ?>
	    </select>
	</div>
	<div id="content"><?= $contents; ?></div>
	</body>
	</html>

	<?php

// autre cas ???
} else {
	die();
}


