// 
// version 1.0
// 2016
// Released under the GPL license
// http://www.gnu.org/copyleft/gpl.html
//
// --------------------------------------------------------------------
//
// ==UserScript==
// @name         Cryptus
// @namespace    http://gogolplex.org/
// @description  Chiffre et déchiffre des messages distants codés avec Cryptus
// @include      http://localhost/htdocs/Cryptus/*
// ==/UserScript==

(function () {
	/////////////////////////////////////////////////////////
	// IMPORTANT // CHANGER LA CLE ET NE LA PERDEZ PAS !!! //
	var key = 'Changez-Ceci_Par Une Suite#De.Caractères+Complexe!';
	// IMPORTANT // CHANGER LA CLE ET NE LA PERDEZ PAS !!! //
	/////////////////////////////////////////////////////////

	// Si les variables login et password sont pré-remplis
	// le formulaire de connexion les postera automatiquement.
	// Sinon, laisser les variables vide et le formulaire s'affichera.
	var login = "";
	var password = "";

	///////////////////////////
	/******* FONCTIONS *******/

	// formulaire de connexion
	function connexion(login, password){

		var connect = document.createElement("form");
		connect.name = 'connect';
		connect.id = 'connect';
		connect.method = 'POST';
		connect.action = '#';

		var l = document.createElement("input");
		l.type = 'text';
		l.name = 'l';
		l.id = 'l';
		l.value = login;
		l.style.margin = '5px';
		l.style.paddingTop = '5px';
		l.style.paddingBottom = '5px';
		connect.appendChild(l);

		var p = document.createElement("input");
		p.type = 'password';
		p.name = 'p';
		p.id = 'p';
		p.value = password;
		p.style.margin = '5px';
		p.style.paddingTop = '5px';
		p.style.paddingBottom = '5px';
		connect.appendChild(p);

		if(login === "" || password === ""){
			
			var btsub = document.createElement("input");
			btsub.type = 'submit';
			btsub.value = 'Connexion'; 
			btsub.style.paddingTop = '5px';
			btsub.style.paddingBottom = '5px';
			connect.appendChild(btsub);
			document.body.appendChild(connect);

		} else { // connexion automatique
			document.body.appendChild(connect);
			connect.submit();
		}
	}

	// affiche certains boutons en fonction de l'url
	function checkUrl(){
		var url = window.location.href;
		var note = url.split("=");
		if(note[1] && note[1] != 0){
			document.getElementById("newbt").style.display = 'none';
			document.getElementById("noteslist").style.display = 'inline-block';
			document.getElementById("editbt").style.display = 'inline-block';
			document.getElementById("cancelbt").style.display = 'none';
			document.getElementById("savebt").style.display = 'none';
			document.getElementById("notename").innerHTML = note[1];
			document.getElementById("notename").style.display = 'none';
		}
	}

	// formulaire d'envoi de data chiffrées
	function sendForm(datax){
		var fofo = document.createElement("form");
		fofo.name = 'fofo';
		fofo.id = 'fofo';
		fofo.method = 'POST';
		fofo.action = '#';

		var txt = document.createElement("textarea");
		txt.name = 'save';
		txt.id = 'save';
		txt.innerHTML = datax; 
		fofo.appendChild(txt);

		document.body.appendChild(fofo);
		fofo.submit();
	}

	// formulaire de créations de nouvelle note
	function newNote(){
		var fifi = document.createElement("form");
		fifi.name = 'fifi';
		fifi.id = 'fifi';
		fifi.margin = '12px';
		fifi.method = 'POST';
		fifi.action = '#';

		var noteName = document.createElement("input");
		noteName.type = 'text';
		noteName.name = 'new';
		noteName.id = 'new';
		noteName.style.width = '300px';
		noteName.value = 'De 3 à 15 caractères alphanumériques'; 
		noteName.onclick = function(){
			document.getElementById("new").value = '';
		}; 
		fifi.appendChild(noteName);

		var btsubmit = document.createElement("input");
		btsubmit.type = 'submit';
		btsubmit.value = 'Créer'; 
		fifi.appendChild(btsubmit);

		document.getElementById("content").appendChild(fifi);
	}

	// compte à rebour 
	function countdown(duration, display) {
	    var timer = duration, minutes, seconds;
	    cd = setInterval(function () {
	            minutes = parseInt(timer / 60, 10);
	            seconds = parseInt(timer % 60, 10);
	            minutes = minutes < 10 ? "0" + minutes : minutes;
	            seconds = seconds < 10 ? "0" + seconds : seconds;
	            display.textContent = minutes + ":" + seconds;

	            if (timer == 120) 
	                alert('La session va bientôt expirer!');
	            if (--timer < 0) { timer = 0;}
	        }, 1000);
	}

	// chiffre abc avec key et retourne xxx si mod === 0
	// déchiffre xxx avec key et retourne abc si mod === 1
	function cryptus(abc, key, mod){
		
		// correspondance entre un caractère ascii et sa valeur binaire
		// charBin = tableau associatif (key)char => (value)bin
		var charBin = [];
		for ( var i = 1; i < 256; i++ ) 
			charBin[String.fromCharCode(i)] = String.fromCharCode(i).charCodeAt(0).toString(2);

		// petit soucis si abc == (vide) avec mod 1
		if(abc == "") mod = 0; 

		var binAbc = [];
		if(mod === 1) 
			binAbc = abc.toString().split(","); // s'il est non null abc est déjà en binaire
		else{
			// convertir abc en binaire
			for (var i = 0; i < abc.length; i++) 
				binAbc.push(charBin[abc[i]]);
		}

		// convertir key en binaire
		// binKey doit obtenir la même longueur que binAbc si key < abc
		var binKey = [];
		for (var i = 0; i < abc.length; i++) {
			if(i < key.length)
				binKey.push(charBin[key[i]]);
			else
				binKey.push(binKey[(i-key.length)]);
		}
		// ici binAbc et binKey sont de même longueur

		// parité XOR
		// (bin)binXor ==  (bin)abc XOR (bin)key
		var binXor = [];
		for (var i = 0; i < binAbc.length; i++) {
			// préparation : les 2 valeurs doivent être de même longueur
			// si binKey == 100100 ($) 
			// et binAbc == 1100011 (c)
			// la parité doit se faire sur 8 bits
			// 00100100 XOR 01100011

			var binA = binAbc[i].split("").reverse();
			var binX = binKey[i].split("").reverse();
			for (var n = 7; n >= 0; n--) {
				binA[n] = (binA[n]) ? binA[n] : 0;
				binX[n] = (binX[n]) ? binX[n] : 0;
			}
			binA.reverse();
			binX.reverse();

			// c'est seulement ici qu'il est possible de calculer la parité
			// xor est de type string car 00000010 vaut 10 en entier
			var xor = '';
			for (var b = 0; b < 8; b++) 
				xor = (binA[b] != binX[b]) ? xor + '1' : xor + '0';

			// transposition binaire vers caractère
			if(mod === 1){
				binXor[i] = String.fromCharCode(parseInt(xor, 2));
				// linearisation du message en string
				var strAbc = "";
				for (var j = 0; j < binXor.length; j++) {
					strAbc = strAbc + binXor[j];
				}
			} else 
				binXor[i] = xor;
		}
		return (mod === 1) ? strAbc : binXor;
	}
	
	/***** FIN FONCTIONS *****/
	///////////////////////////

	///////////////////////////
	/********** VUE **********/

	// la page.php retourne une div#content seulement si on est connecté
	// si cette div n'existe pas => affiche le formulaire de connexion
	if(!document.getElementById("content")) {
		connexion(login, password);
	} else {

		// connexion établie avec la page.php
		var xxx = document.getElementById("content").innerHTML;

		// image logout
		var cadenas = "data:image/png;base64,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";
		var im = document.createElement("img");
		im.id = 'cadenas'; 
		im.src = cadenas;
		im.style.cursor = 'pointer';
		im.style.cssFloat = 'right';
		im.alt = 'Se déconnecter';
		im.title = 'Déconnexion';
		im.onclick = function(){
			if(login === "" || password === ""){
				var url = window.location.pathname + '?logout';
				window.location.href = url;
			} else {
				alert("\tDECONNEXION IMPOSSIBLE\nTant que les variables du scripte [login] et [password] ne seront pas vides il vous sera impossible de vous déconnecter!");
			}
			
		}; 
		document.getElementById("menu").appendChild(im);

		// compte à rebour
		var timer = document.createElement("span");
		timer.id = 'timer';
		timer.style.display = 'inline-block';
		timer.style.cssFloat = 'right';
		document.getElementById("menu").appendChild(timer);
		countdown(1440, document.querySelector('#timer'));

		// titre d'une note (nom de fichier) 
		var title = document.createElement("span");
		title.id = 'notename';
		title.style.display = 'none';
		title.style.cssFloat = 'right';
		document.getElementById("menu").appendChild(title);

		// création des 4 boutons | edit | cancel | save | new |
		////////////////////////////////////////////////////////
		// bouton d'édition
		var btEdit = document.createElement("button");
		btEdit.id = 'editbt';
		btEdit.style.display = 'none';
		btEdit.innerHTML = 'Éditeur'; 
		btEdit.onclick = function(){
			document.getElementById("content").innerHTML = '<textarea id="composer">'+ cryptus(xxx, key, 1) +'</textarea>';
			document.getElementById("noteslist").style.display = 'none';
			document.getElementById("editbt").style.display = 'none';
			document.getElementById("newbt").style.display = 'none';
			document.getElementById("cancelbt").style.display = 'inline-block';
			document.getElementById("savebt").style.display = 'inline-block';
			document.getElementById("notename").style.display = 'inline-block';
		}; 
		document.getElementById("menu").appendChild(btEdit);
		// bt cancel
		var btCancel = document.createElement("button");
		btCancel.id = 'cancelbt';
		btCancel.style.display = 'none'; 
		btCancel.innerHTML = 'Annuler'; 
		btCancel.onclick = function(){
			document.getElementById("content").innerHTML = xxx;
			checkUrl();
		}; 
		document.getElementById("menu").appendChild(btCancel);
		// bouton save
		var btSave = document.createElement("button");
		btSave.id = 'savebt';
		btSave.style.display = 'none'; 
		btSave.innerHTML = 'Sauvegarder'; 
		btSave.onclick = function(){
			var x = cryptus(document.getElementById("composer").value, key, 0);
			sendForm(x);
		}; 
		document.getElementById("menu").appendChild(btSave);
		// bouton new
		var btNew = document.createElement("button");
		btNew.id = 'newbt';
		btNew.style.display = 'inline-block'; 
		btNew.innerHTML = 'Nouvelle'; 
		btNew.onclick = function(){
			document.getElementById("content").innerHTML = '';
			document.getElementById("noteslist").style.display = 'none';
			document.getElementById("cancelbt").style.display = 'none';
			document.getElementById("savebt").style.display = 'none';
			document.getElementById("editbt").style.display = 'none';
			document.getElementById("newbt").style.display = 'none';
			newNote();
		}; 
		document.getElementById("menu").appendChild(btNew);

		// afficher la page en fonction du choix courrant
		checkUrl();

	}

})();


